'use strict';var LiveValidation=Class.create();Object.extend(LiveValidation,{VERSION:"1.4 prototype",TEXTAREA:1,TEXT:2,PASSWORD:3,CHECKBOX:4,SELECT:5,FILE:6,massValidate:function(b){for(var a=!0,c=0,e=b.length;c<e;++c){var d=b[c].validate();a&&=d}return a}});
LiveValidation.prototype={validClass:"LV_valid",invalidClass:"LV_invalid",messageClass:"LV_validation_message",validFieldClass:"LV_valid_field",invalidFieldClass:"LV_invalid_field",initialize:function(b,a){if(!b)throw Error("LiveValidation::initialize - No element reference or element id has been provided!");this.element=$(b);if(!this.element)throw Error("LiveValidation::initialize - No element with reference or id of '"+b+"' exists!");this.elementType=this.getElementType();this.validations=[];this.form=
this.element.form;this.options=Object.extend({validMessage:"Thankyou!",insertAfterWhatNode:this.element,onlyOnBlur:!1,wait:0,onlyOnSubmit:!1,beforeValidation:function(){},beforeValid:function(){},onValid:function(){this.insertMessage(this.createMessageSpan());this.addFieldClass()},afterValid:function(){},beforeInvalid:function(){},onInvalid:function(){this.insertMessage(this.createMessageSpan());this.addFieldClass()},afterInvalid:function(){},afterValidation:function(){}},a||{});this.options.insertAfterWhatNode=
$(this.options.insertAfterWhatNode||this.element);Object.extend(this,this.options);this.form&&(this.formObj=LiveValidationForm.getInstance(this.form),this.formObj.addField(this));this.cFocus=this.doOnFocus.bindAsEventListener(this);Event.observe(this.element,"focus",this.cFocus);if(!this.onlyOnSubmit)switch(this.elementType){case LiveValidation.CHECKBOX:this.cClick=this.validate.bindAsEventListener(this),Event.observe(this.element,"click",this.cClick);case LiveValidation.SELECT:case LiveValidation.FILE:this.cChange=
this.validate.bindAsEventListener(this);Event.observe(this.element,"change",this.cChange);break;default:this.onlyOnBlur||(this.cKeyup=this.deferValidation.bindAsEventListener(this),Event.observe(this.element,"keyup",this.cKeyup)),this.cBlur=this.validate.bindAsEventListener(this),Event.observe(this.element,"blur",this.cBlur)}},destroy:function(){this.formObj&&(this.formObj.removeField(this),this.formObj.destroy());var b=this.element;Event.stopObserving(b,"focus",this.cFocus);if(!this.onlyOnSubmit)switch(this.elementType){case LiveValidation.CHECKBOX:Event.stopObserving(b,
"click",this.cClick);case LiveValidation.SELECT:case LiveValidation.FILE:Event.stopObserving(b,"change",this.cChange);break;default:this.onlyOnBlur||Event.stopObserving(b,"keyup",this.cKeyup),Event.stopObserving(b,"blur",this.cBlur)}this.validations=[];this.removeMessageAndFieldClass()},add:function(b,a){this.validations.push({type:b,params:a||{}});return this},remove:function(b,a){this.validations=this.validations.reject(function(c){return c.type==b&&c.params==a});return this},deferValidation:function(b){300<=
this.wait&&this.removeMessageAndFieldClass();this.timeout&&clearTimeout(this.timeout);this.timeout=setTimeout(this.validate.bind(this),this.wait)},doOnBlur:function(){this.focused=!1;this.validate()},doOnFocus:function(){this.focused=!0;this.removeMessageAndFieldClass()},getElementType:function(){var b=this.element.nodeName.toUpperCase(),a=this.element.type.toUpperCase();switch(!0){case "TEXTAREA"==b:return LiveValidation.TEXTAREA;case "INPUT"==b&&"TEXT"==a:return LiveValidation.TEXT;case "INPUT"==
b&&"PASSWORD"==a:return LiveValidation.PASSWORD;case "INPUT"==b&&"CHECKBOX"==a:return LiveValidation.CHECKBOX;case "INPUT"==b&&"FILE"==a:return LiveValidation.FILE;case "SELECT"==b:return LiveValidation.SELECT;case "INPUT"==b:throw Error("LiveValidation::getElementType - Cannot use LiveValidation on an "+a.toLowerCase()+" input!");default:throw Error("LiveValidation::getElementType - Element must be an input, select, or textarea - "+b.toLowerCase()+" was given!");}},doValidations:function(){this.validationFailed=
!1;for(var b=0,a=this.validations.length;b<a;++b)if(this.validationFailed=!this.validateElement(this.validations[b].type,this.validations[b].params))return!1;this.message=this.validMessage;return!0},validateElement:function(b,a){switch(b){case Validate.Presence:case Validate.Confirmation:case Validate.Acceptance:this.displayMessageWhenEmpty=!0;break;case Validate.Custom:a.displayMessageWhenEmpty&&(this.displayMessageWhenEmpty=!0)}var c=this.elementType==LiveValidation.SELECT?this.element.options[this.element.selectedIndex].value:
this.element.value;if(b==Validate.Acceptance){if(this.elementType!=LiveValidation.CHECKBOX)throw Error("LiveValidation::validateElement - Element to validate acceptance must be a checkbox!");c=this.element.checked}var e=!0;try{b(c,a)}catch(d){if(d instanceof Validate.Error){if(""!==c||""===c&&this.displayMessageWhenEmpty)this.validationFailed=!0,this.message=d.message.split("\n")[0],e=!1}else throw d;}finally{return e}},validate:function(){if(this.element.disabled)return!0;this.beforeValidation();
var b=this.doValidations();b?(this.beforeValid(),this.onValid(),this.afterValid()):(this.beforeInvalid(),this.onInvalid(),this.afterInvalid());this.afterValidation();return b},enable:function(){this.element.disabled=!1;return this},disable:function(){this.element.disabled=!0;this.removeMessageAndFieldClass();return this},createMessageSpan:function(){var b=document.createElement("span"),a=document.createTextNode(this.message);b.appendChild(a);return b},insertMessage:function(b){this.removeMessage();
if(this.validationFailed||this.validMessage)if(this.displayMessageWhenEmpty&&(this.elementType==LiveValidation.CHECKBOX||""==this.element.value)||""!=this.element.value){var a=this.validationFailed?this.invalidClass:this.validClass;$(b).addClassName(this.messageClass+" "+a);a=this.insertAfterWhatNode.up();var c=this.insertAfterWhatNode.next();c?a.insertBefore(b,c):a.appendChild(b)}},addFieldClass:function(){this.removeFieldClass();if(this.validationFailed)this.element.hasClassName(this.invalidFieldClass)||
this.element.addClassName(this.invalidFieldClass);else if(this.displayMessageWhenEmpty||""!=this.element.value)this.element.hasClassName(this.validFieldClass)||this.element.addClassName(this.validFieldClass)},removeMessage:function(){var b=this.insertAfterWhatNode.next("."+this.messageClass);b&&b.remove()},removeFieldClass:function(){this.element.removeClassName(this.invalidFieldClass);this.element.removeClassName(this.validFieldClass)},removeMessageAndFieldClass:function(){this.removeMessage();this.removeFieldClass()}};
var LiveValidationForm=Class.create();Object.extend(LiveValidationForm,{instances:{},getInstance:function(b){if(!b)throw Error("LiveValidationForm::getInstance - No element reference or element id has been provided!");b=$(b);var a=Math.random()*Math.random();b.id||(b.id="formId_"+a.toString().replace(/\./,"")+(new Date).valueOf());LiveValidationForm.instances[b.id]||(LiveValidationForm.instances[b.id]=new LiveValidationForm(b));return LiveValidationForm.instances[b.id]}});
LiveValidationForm.prototype={beforeValidation:function(){},onValid:function(){},onInvalid:function(){},afterValidation:function(){},initialize:function(b){this.element=$(b);this.fields=[];this.oldOnSubmit=this.element.onsubmit||function(){};this.element.onsubmit=function(a){var c=!1;this.beforeValidation();(this.valid=LiveValidation.massValidate(this.fields))?this.onValid():this.onInvalid();this.afterValidation();this.valid&&(c=!1!==this.oldOnSubmit.call(this.element,a));c||Event.stop(a)}.bindAsEventListener(this)},
addField:function(b){this.fields.push(b)},removeField:function(b){this.fields=this.fields.without(b)},destroy:function(b){if(0!=this.fields.length&&!b)return!1;this.element.onsubmit=this.oldOnSubmit;LiveValidationForm.instances[this.element.id]=null;return!0}};
var Validate={Presence:function(b,a){a=Object.extend({failureMessage:"Can't be empty!"},a||{});""!==b&&null!==b&&void 0!==b||Validate.fail(a.failureMessage);return!0},Numericality:function(b,a){var c=b;b=Number(b);a=a||{};var e=a.notANumberMessage||"Must be a number!",d=a.notAnIntegerMessage||"Must be an integer!",g=a.wrongNumberMessage||"Must be "+a.is+"!",f=a.tooLowMessage||"Must not be less than "+a.minimum+"!",l=a.tooHighMessage||"Must not be more than "+a.maximum+"!",m=a.is||0==a.is?a.is:null,
h=a.minimum||0==a.minimum?a.minimum:null,k=a.maximum||0==a.maximum?a.maximum:null;a=a.onlyInteger||!1;isFinite(b)||Validate.fail(e);a&&(/\.0+$|\.$/.test(String(c))||b!=parseInt(b))&&Validate.fail(d);switch(!0){case null!==m:b!=Number(m)&&Validate.fail(g);break;case null!==h&&null!==k:Validate.Numericality(b,{tooLowMessage:f,minimum:h});Validate.Numericality(b,{tooHighMessage:l,maximum:k});break;case null!==h:b<Number(h)&&Validate.fail(f);break;case null!==k:b>Number(k)&&Validate.fail(l)}return!0},
Format:function(b,a){b=String(b);a=Object.extend({failureMessage:"Not valid!",pattern:/./,negate:!1},a||{});a.negate||a.pattern.test(b)||Validate.fail(a.failureMessage);a.negate&&a.pattern.test(b)&&Validate.fail(a.failureMessage);return!0},Email:function(b,a){a=Object.extend({failureMessage:"Must be a valid email address!"},a||{});Validate.Format(b,{failureMessage:a.failureMessage,pattern:/^([^@\s]+)@((?:[-a-z0-9]+\.)+[a-z]{2,})$/i});return!0},Length:function(b,a){b=String(b);a=a||{};var c=a.wrongLengthMessage||
"Must be "+a.is+" characters long!",e=a.tooShortMessage||"Must not be less than "+a.minimum+" characters long!",d=a.tooLongMessage||"Must not be more than "+a.maximum+" characters long!",g=a.is||0==a.is?a.is:null,f=a.minimum||0==a.minimum?a.minimum:null;a=a.maximum||0==a.maximum?a.maximum:null;switch(!0){case null!==g:b.length!=Number(g)&&Validate.fail(c);break;case null!==f&&null!==a:Validate.Length(b,{tooShortMessage:e,minimum:f});Validate.Length(b,{tooLongMessage:d,maximum:a});break;case null!==
f:b.length<Number(f)&&Validate.fail(e);break;case null!==a:b.length>Number(a)&&Validate.fail(d);break;default:throw Error("Validate::Length - Length(s) to validate against must be provided!");}return!0},Inclusion:function(b,a){a=Object.extend({failureMessage:"Must be included in the list!",within:[],allowNull:!1,partialMatch:!1,caseSensitive:!0,negate:!1},a||{});if(a.allowNull&&null==b)return!0;a.allowNull||null!=b||Validate.fail(a.failureMessage);if(!a.caseSensitive){var c=[];a.within.each(function(d){"string"==
typeof d&&(d=d.toLowerCase());c.push(d)});a.within=c;"string"==typeof b&&(b=b.toLowerCase())}var e=-1==a.within.indexOf(b)?!1:!0;a.partialMatch&&(e=!1,a.within.each(function(d){-1!=b.indexOf(d)&&(e=!0)}));(!a.negate&&!e||a.negate&&e)&&Validate.fail(a.failureMessage);return!0},Exclusion:function(b,a){a=Object.extend({failureMessage:"Must not be included in the list!",within:[],allowNull:!1,partialMatch:!1,caseSensitive:!0},a||{});a.negate=!0;Validate.Inclusion(b,a);return!0},Confirmation:function(b,
a){if(!a.match)throw Error("Validate::Confirmation - Error validating confirmation: Id of element to match must be provided!");var c=Object.extend({failureMessage:"Does not match!",match:null},a||{});c.match=$(a.match);if(!c.match)throw Error("Validate::Confirmation - There is no reference with name of, or element with id of '"+c.match+"'!");b!=c.match.value&&Validate.fail(c.failureMessage);return!0},Acceptance:function(b,a){a=Object.extend({failureMessage:"Must be accepted!"},a||{});b||Validate.fail(a.failureMessage);
return!0},Custom:function(b,a){a=Object.extend({against:function(){return!0},args:{},failureMessage:"Not valid!"},a||{});a.against(b,a.args)||Validate.fail(a.failureMessage);return!0},now:function(b,a,c){if(!b)throw Error("Validate::now - Validation function must be provided!");var e=!0;try{b(a,c||{})}catch(d){if(d instanceof Validate.Error)e=!1;else throw d;}finally{return e}},Error:function(b){this.message=b;this.name="ValidationError"},fail:function(b){throw new Validate.Error(b);}};

//# sourceMappingURL=livevalidation_prototype.min.js.map
